<?php
// =========================================================================
// Bagian 3: Views (Tampilan)
// Tampilan ini mengintegrasikan AdminLTE, Tailwind, dan Datatables.
// =========================================================================
?>
<!-- File: application/views/templates/header.php -->
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= $title ?></title>

    <!-- AdminLTE CSS CDN -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
    
    <!-- Datatables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.25/css/jquery.dataTables.min.css">
    
    <!-- Tailwind CSS (sebagai kustomisasi) -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Font Awesome untuk ikon -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

    <style>
        /* Gaya kustom untuk menyesuaikan tampilan dengan Fiori/Tailwind */
        body {
            font-family: 'Inter', sans-serif;
        }
        .card {
            border-radius: 1rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .btn {
            border-radius: 9999px; /* Rounded pill buttons */
            transition: all 0.3s ease;
        }
        .dataTables_wrapper .dataTables_paginate .paginate_button {
            border-radius: 9999px;
            margin: 0 4px;
        }
    </style>
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">
    <!-- Navbar -->
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
        <ul class="navbar-nav">
            <li class="nav-item">
                <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
            </li>
        </ul>
        <span class="ml-auto text-lg font-semibold">Dasbor Marketplace</span>
        <ul class="navbar-nav ml-auto">
             <!-- Notifikasi Dropdown -->
             <li class="nav-item dropdown">
                <a class="nav-link" data-toggle="dropdown" href="#">
                    <i class="far fa-bell"></i>
                    <span id="notification-count" class="badge badge-warning navbar-badge">0</span>
                </a>
                <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right" id="notification-list">
                    <span class="dropdown-item dropdown-header" id="notification-header">0 Notifikasi</span>
                    <div id="notification-items-container">
                        <!-- Notifikasi akan dimuat di sini oleh AJAX -->
                    </div>
                    <a href="#" class="dropdown-item dropdown-footer text-center" id="mark-all-read">Tandai Semua Sudah Dibaca</a>
                </div>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="<?= base_url('auth/logout') ?>">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </li>
        </ul>
    </nav>
    <!-- Sidebar -->
    <aside class="main-sidebar sidebar-dark-primary elevation-4">
        <a href="<?= base_url() ?>" class="brand-link">
            <span class="brand-text font-weight-light">Marketplace</span>
        </a>
        <div class="sidebar">
            <nav class="mt-2">
                <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                    <li class="nav-item">
                        <a href="<?= base_url('dashboard') ?>" class="nav-link <?= ($this->uri->segment(1) == 'dashboard') ? 'active' : '' ?>">
                            <i class="nav-icon fas fa-tachometer-alt"></i>
                            <p>Dasbor</p>
                        </a>
                    </li>
                    <?php if ($this->session->userdata('role_id') == 2 || $this->session->userdata('role_id') == 1): // Merchant & Admin ?>
                    <li class="nav-item has-treeview <?= ($this->uri->segment(1) == 'products') ? 'menu-open' : '' ?>">
                        <a href="#" class="nav-link <?= ($this->uri->segment(1) == 'products') ? 'active' : '' ?>">
                            <i class="nav-icon fas fa-shopping-cart"></i>
                            <p>
                                Manajemen Produk
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?= base_url('products/manage') ?>" class="nav-link <?= ($this->uri->segment(2) == 'manage') ? 'active' : '' ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Produk Saya</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <?php endif; ?>
                    <?php if ($this->session->userdata('role_id') == 1): // Admin ?>
                    <li class="nav-item has-treeview <?= ($this->uri->segment(1) == 'accounting') ? 'menu-open' : '' ?>">
                        <a href="#" class="nav-link <?= ($this->uri->segment(1) == 'accounting') ? 'active' : '' ?>">
                            <i class="nav-icon fas fa-chart-line"></i>
                            <p>
                                Akuntansi
                                <i class="right fas fa-angle-left"></i>
                            </p>
                        </a>
                        <ul class="nav nav-treeview">
                            <li class="nav-item">
                                <a href="<?= base_url('accounting/general_ledger') ?>" class="nav-link <?= ($this->uri->segment(2) == 'general_ledger') ? 'active' : '' ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Buku Besar</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?= base_url('accounting/profit_and_loss') ?>" class="nav-link <?= ($this->uri->segment(2) == 'profit_and_loss') ? 'active' : '' ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Laba Rugi</p>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a href="<?= base_url('accounting/cash_flow') ?>" class="nav-link <?= ($this->uri->segment(2) == 'cash_flow') ? 'active' : '' ?>">
                                    <i class="far fa-circle nav-icon"></i>
                                    <p>Arus Kas</p>
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a href="<?= base_url('payments') ?>" class="nav-link <?= ($this->uri->segment(1) == 'payments') ? 'active' : '' ?>">
                            <i class="nav-icon fas fa-money-check-alt"></i>
                            <p>Pembayaran</p>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if ($this->session->userdata('role_id') == 4): // Customer ?>
                    <li class="nav-item">
                        <a href="<?= base_url('products') ?>" class="nav-link <?= ($this->uri->segment(1) == 'products' && $this->uri->segment(2) == '') ? 'active' : '' ?>">
                            <i class="nav-icon fas fa-shopping-basket"></i>
                            <p>Belanja Produk</p>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </nav>
        </div>
    </aside>
    <!-- Konten Utama -->
    <div class="content-wrapper">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0"><?= $title ?></h1>
                    </div>
                </div>
            </div>
        </div>
        <div class="content">
            <div class="container-fluid">
                <!-- Konten akan dimuat di sini -->
