<!-- File: application/views/templates/public_header.php (View Baru) -->
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($title) ? htmlspecialchars($title) : 'Selamat Datang' ?></title>
    <meta name="description" content="<?= isset($meta_description) ? htmlspecialchars($meta_description) : '' ?>">
    <meta name="keywords" content="<?= isset($meta_keywords) ? htmlspecialchars($meta_keywords) : '' ?>">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700;800&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
        .prose { max-width: none; }
    </style>
</head>
<body class="bg-gray-50 text-gray-800">
    <header class="bg-white shadow-sm sticky top-0 z-50">
        <nav class="container mx-auto px-6 py-4 flex justify-between items-center">
            <a href="<?= base_url() ?>" class="text-2xl font-bold text-indigo-600">
                <i class="fas fa-store mr-2"></i>SKB Market
            </a>
            <div class="space-x-2 md:space-x-4">
                <a href="<?= base_url('catalog') ?>" class="text-gray-600 hover:text-indigo-600 px-3 py-2 rounded-md">Produk</a>
                <a href="#" class="text-gray-600 hover:text-indigo-600 px-3 py-2 rounded-md">Login</a>
                <a href="#" class="bg-indigo-600 text-white px-4 py-2 rounded-full hover:bg-indigo-700 transition-colors">Daftar</a>
            </div>
        </nav>
    </header>
    <main class="container mx-auto px-6 py-8">