<!-- File: application/views/templates/public_footer.php (View Baru) -->
    </main>
    <footer class="bg-gray-800 text-white py-8 mt-12">
        <div class="container mx-auto px-6 text-center">
            <p>&copy; <?= date('Y') ?> SKB Market. All rights reserved.</p>
        </div>
    </footer>
</body>
</html>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- AdminLTE JS -->
<script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
<!-- Datatables JS -->
<script src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>

<script>
    $(document).ready(function() {
        // Inisialisasi Datatables
        $('#transactions-table').DataTable();
        $('#products-table').DataTable();
        $('#journals-table').DataTable();
        $('#affiliate-sales-table').DataTable();
        $('#commissions-table').DataTable();
        $('#affiliate-performance-table').DataTable();
        $('#sales-by-product-table').DataTable();
        $('#cash-flow-table').DataTable();
        $('#manage-products-table').DataTable();
        
        // Memuat notifikasi saat halaman dimuat
        function fetchNotifications() {
            $.ajax({
                url: '<?= base_url('dashboard/get_notifications') ?>',
                type: 'GET',
                success: function(response) {
                    $('#notification-count').text(response.count);
                    $('#notification-header').text(response.count + ' Notifikasi Belum Dibaca');
                    $('#notification-items-container').empty();
                    
                    if (response.count > 0) {
                        $.each(response.notifications, function(index, notif) {
                            var notifHtml = '<a href="#" class="dropdown-item">' +
                                                '<div class="media">' +
                                                    '<div class="media-body">' +
                                                        '<h3 class="dropdown-item-title">' + notif.message + '</h3>' +
                                                        '<p class="text-sm text-muted"><i class="far fa-clock mr-1"></i> ' + notif.created_at + '</p>' +
                                                    '</div>' +
                                                '</div>' +
                                            '</a>' +
                                            '<div class="dropdown-divider"></div>';
                            $('#notification-items-container').append(notifHtml);
                        });
                    } else {
                        $('#notification-items-container').html('<span class="dropdown-item text-center">Tidak ada notifikasi baru</span>');
                    }
                },
                error: function() {
                    console.log('Failed to fetch notifications.');
                }
            });
        }
        
        fetchNotifications();
        
        // Memperbarui notifikasi setiap 60 detik
        setInterval(fetchNotifications, 60000);
    });
</script>
</body>
</html>
