<!-- File: application/views/produk/index.php (View Baru) -->
<div class="bg-white p-8 rounded-xl shadow-md mb-8">
    <h1 class="text-3xl font-bold mb-2"><?= $title ?></h1>
    <p class="text-gray-600"><?= $meta_description ?></p>
</div>
<div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-8">
    <?php if (!empty($barang_list)): ?>
        <?php foreach ($barang_list as $barang): ?>
            <div class="bg-white rounded-lg shadow-lg overflow-hidden transform hover:-translate-y-2 transition-transform duration-300 group">
                <a href="<?= base_url('produk/' . htmlspecialchars($barang->slug)) ?>">
                    <div class="bg-gray-200 h-48 w-full flex items-center justify-center overflow-hidden">
                        <?php if (!empty($barang->gambar)): ?>
                            <img src="<?= htmlspecialchars($barang->gambar) ?>" alt="<?= htmlspecialchars($barang->nama_barang) ?>" class="h-full w-full object-cover group-hover:scale-110 transition-transform duration-300">
                        <?php else: ?>
                            <i class="fas fa-camera text-4xl text-gray-400"></i>
                        <?php endif; ?>
                    </div>
                    <div class="p-6">
                        <h2 class="text-lg font-bold text-gray-800 truncate" title="<?= htmlspecialchars($barang->nama_barang) ?>"><?= htmlspecialchars($barang->nama_barang) ?></h2>
                        <p class="text-indigo-600 font-semibold mt-2">Rp <?= number_format($barang->harga, 0, ',', '.') ?></p>
                    </div>
                </a>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <p class="col-span-full text-center text-gray-500 py-16">Belum ada produk yang tersedia saat ini.</p>
    <?php endif; ?>
</div>
