<!-- File: application/views/produk/detail.php (View Baru) -->
<div class="bg-white p-8 rounded-xl shadow-lg">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-12">
        <!-- Kolom Gambar Produk -->
        <div>
            <div class="bg-gray-200 h-96 w-full rounded-lg flex items-center justify-center mb-4 overflow-hidden">
                 <?php if (!empty($barang->gambar)): ?>
                    <img src="<?= htmlspecialchars($barang->gambar) ?>" alt="<?= htmlspecialchars($barang->nama_barang) ?>" class="h-full w-full object-cover">
                <?php else: ?>
                    <i class="fas fa-camera text-6xl text-gray-400"></i>
                <?php endif; ?>
            </div>
            <!-- Anda bisa menambahkan galeri gambar di sini jika ada tabel `tbl_gambar` -->
        </div>

        <!-- Kolom Detail Produk -->
        <div>
            <h1 class="text-4xl font-extrabold text-gray-900 my-3"><?= htmlspecialchars($barang->nama_barang) ?></h1>
            <p class="text-3xl font-bold text-indigo-600 mb-6">Rp <?= number_format($barang->harga, 0, ',', '.') ?></p>
            
            <!-- Fitur Utama dengan Ikon -->
            <div class="mb-6 border-t border-b border-gray-200 py-4">
                <div class="grid grid-cols-2 gap-4 text-sm">
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-check-circle text-green-500 w-5 text-center"></i>
                        <span>Produk Original</span>
                    </div>
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-shield-alt text-blue-500 w-5 text-center"></i>
                        <span>Transaksi Aman</span>
                    </div>
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-box-open text-yellow-500 w-5 text-center"></i>
                        <span>Stok: <?= htmlspecialchars($barang->stok) ?></span>
                    </div>
                    <div class="flex items-center space-x-3">
                        <i class="fas fa-percent text-purple-500 w-5 text-center"></i>
                        <span>Komisi Afiliasi: <?= htmlspecialchars($barang->komisi) ?>%</span>
                    </div>
                </div>
            </div>

            <div class="mb-6">
                <h3 class="text-lg font-semibold text-gray-800 mb-2">Deskripsi Produk</h3>
                <div class="text-gray-600 leading-relaxed prose">
                    <?= !empty($barang->deskripsi_seo) ? $barang->deskripsi_seo : nl2br(htmlspecialchars($barang->deskripsi)) ?>
                </div>
            </div>

            <!-- Tombol CTA Checkout -->
            <a href="#" class="w-full text-center bg-indigo-600 text-white font-bold py-4 px-8 rounded-full hover:bg-indigo-700 transition-colors text-lg inline-block transform hover:scale-105 duration-300 ease-in-out shadow-lg">
                <i class="fas fa-shopping-cart mr-2"></i> Beli Sekarang
            </a>
            
            <!-- Tombol Berbagi Sosial Media -->
            <div class="mt-6 text-center">
                <span class="text-sm font-semibold text-gray-600 mr-4">Bagikan:</span>
                <div class="inline-flex space-x-3">
                    <?php
                        $share_url = urlencode(current_url());
                        $share_text = urlencode("Lihat produk keren ini: " . $barang->nama_barang);
                    ?>
                    <a href="https://www.facebook.com/sharer/sharer.php?u=<?= $share_url ?>" target="_blank" class="text-gray-500 hover:text-blue-800 transition-colors h-8 w-8 rounded-full flex items-center justify-center bg-gray-200 hover:bg-gray-300">
                        <i class="fab fa-facebook-f"></i>
                    </a>
                    <a href="https://twitter.com/intent/tweet?url=<?= $share_url ?>&text=<?= $share_text ?>" target="_blank" class="text-gray-500 hover:text-blue-500 transition-colors h-8 w-8 rounded-full flex items-center justify-center bg-gray-200 hover:bg-gray-300">
                        <i class="fab fa-twitter"></i>
                    </a>
                    <a href="https://api.whatsapp.com/send?text=<?= $share_text ?> <?= $share_url ?>" target="_blank" class="text-gray-500 hover:text-green-600 transition-colors h-8 w-8 rounded-full flex items-center justify-center bg-gray-200 hover:bg-gray-300">
                        <i class="fab fa-whatsapp"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>