<!-- Filee: application/views/products/manage.php -->
<div class="container-fluid">
    <div class="card p-4">
        <div class="card-header bg-white border-b border-gray-200 py-3 flex justify-between items-center">
            <h3 class="card-title text-xl font-semibold">Manajemen Produk Saya</h3>
            <a href="<?= base_url('products/form') ?>" class="btn btn-primary bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 text-sm">
                <i class="fas fa-plus mr-1"></i> Tambah Produk Baru
            </a>
        </div>
        <div class="card-body">
            <?php if ($this->session->flashdata('success')): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg relative mb-4" role="alert">
                    <?= $this->session->flashdata('success') ?>
                </div>
            <?php endif; ?>
            <table id="manage-products-table" class="display w-full text-sm">
                <thead>
                    <tr>
                        <th class="p-2 text-left text-gray-600 font-semibold">ID</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Nama Produk</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Harga</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Stok</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Komisi (%)</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($products as $product): ?>
                        <tr class="hover:bg-gray-100">
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($product['id']) ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($product['name']) ?></td>
                            <td class="p-2 border-b border-gray-200">Rp <?= number_format($product['price'], 0, ',', '.') ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($product['stock']) ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($product['affiliate_commission_rate']) ?>%</td>
                            <td class="p-2 border-b border-gray-200">
                                <a href="<?= base_url('products/form/' . $product['id']) ?>" class="bg-yellow-500 hover:bg-yellow-600 text-white font-bold py-1 px-3 rounded-full text-xs">Edit</a>
                                <a href="<?= base_url('products/delete/' . $product['id']) ?>" onclick="return confirm('Apakah Anda yakin ingin menghapus produk ini?')" class="bg-red-500 hover:bg-red-600 text-white font-bold py-1 px-3 rounded-full text-xs">Hapus</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
