<!-- Filee: application/views/products/index.php -->
<div class="container-fluid">
    <div class="card p-4">
        <div class="card-header bg-white border-b border-gray-200 py-3">
            <h3 class="card-title text-xl font-semibold">Daftar Produk</h3>
        </div>
        <div class="card-body">
            <table id="products-table" class="display w-full text-sm">
                <thead>
                    <tr>
                        <th class="p-2 text-left text-gray-600 font-semibold">ID</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Nama Produk</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Deskripsi</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Harga</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($products as $product): ?>
                        <tr class="hover:bg-gray-100">
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($product['id']) ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($product['name']) ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($product['description']) ?></td>
                            <td class="p-2 border-b border-gray-200">Rp <?= number_format($product['price'], 0, ',', '.') ?></td>
                            <td class="p-2 border-b border-gray-200">
                                <a href="<?= base_url('checkout/index/' . $product['id']) ?>" class="bg-green-500 hover:bg-green-600 text-white font-bold py-1 px-3 rounded-full text-xs">Beli</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
