<!-- Filee: application/views/products/form.php -->
<div class="container-fluid">
    <div class="card p-8 w-full md:w-2/3 mx-auto">
        <h2 class="text-2xl font-bold mb-4"><?= $title ?></h2>
        <?= validation_errors('<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg relative mb-4">', '</div>'); ?>
        <?= form_open('products/save'); ?>
            <input type="hidden" name="product_id" value="<?= isset($product) ? htmlspecialchars($product->id) : '' ?>">
            <?= form_hidden($this->security->get_csrf_token_name(), $this->security->get_csrf_hash()); ?>
            <div class="mb-4">
                <label for="name" class="block text-gray-700 font-semibold mb-2">Nama Produk</label>
                <input type="text" name="name" id="name" class="w-full px-4 py-2 border rounded-md focus:outline-none focus:ring focus:ring-blue-200" value="<?= set_value('name', isset($product) ? $product->name : '') ?>">
            </div>
            <div class="mb-4">
                <label for="description" class="block text-gray-700 font-semibold mb-2">Deskripsi</label>
                <textarea name="description" id="description" class="w-full px-4 py-2 border rounded-md focus:outline-none focus:ring focus:ring-blue-200"><?= set_value('description', isset($product) ? $product->description : '') ?></textarea>
            </div>
            <div class="mb-4">
                <label for="price" class="block text-gray-700 font-semibold mb-2">Harga</label>
                <input type="number" name="price" id="price" class="w-full px-4 py-2 border rounded-md focus:outline-none focus:ring focus:ring-blue-200" value="<?= set_value('price', isset($product) ? $product->price : '') ?>">
            </div>
            <div class="mb-4">
                <label for="stock" class="block text-gray-700 font-semibold mb-2">Stok</label>
                <input type="number" name="stock" id="stock" class="w-full px-4 py-2 border rounded-md focus:outline-none focus:ring focus:ring-blue-200" value="<?= set_value('stock', isset($product) ? $product->stock : '') ?>">
            </div>
            <div class="mb-6">
                <label for="affiliate_commission_rate" class="block text-gray-700 font-semibold mb-2">Komisi Afiliasi (%)</label>
                <input type="number" name="affiliate_commission_rate" id="affiliate_commission_rate" step="0.01" class="w-full px-4 py-2 border rounded-md focus:outline-none focus:ring focus:ring-blue-200" value="<?= set_value('affiliate_commission_rate', isset($product) ? $product->affiliate_commission_rate : '') ?>">
            </div>
            <button type="submit" class="w-full bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded-full transition-colors duration-300">Simpan Produk</button>
        <?= form_close(); ?>
    </div>
</div>
