<!-- Filee: application/views/payments/index.php -->
<div class="container-fluid">
    <div class="card p-4">
        <div class="card-header bg-white border-b border-gray-200 py-3">
            <h3 class="card-title text-xl font-semibold">Daftar Komisi Menunggu Pembayaran</h3>
        </div>
        <div class="card-body">
            <?php if ($this->session->flashdata('success')): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg relative mb-4" role="alert">
                    <?= $this->session->flashdata('success') ?>
                </div>
            <?php endif; ?>
            <?php if ($this->session->flashdata('error')): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg relative mb-4" role="alert">
                    <?= $this->session->flashdata('error') ?>
                </div>
            <?php endif; ?>
            <table id="commissions-table" class="display w-full text-sm">
                <thead>
                    <tr>
                        <th class="p-2 text-left text-gray-600 font-semibold">ID Afiliasi</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Username</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Total Komisi Dihasilkan</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Total Dibayar</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Saldo Tertunda</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($commissions as $commission): ?>
                        <tr class="hover:bg-gray-100">
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($commission['affiliate_id']) ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($commission['username']) ?></td>
                            <td class="p-2 border-b border-gray-200">Rp <?= number_format($commission['total_generated'], 0, ',', '.') ?></td>
                            <td class="p-2 border-b border-gray-200">Rp <?= number_format($commission['total_paid'] ?? 0, 0, ',', '.') ?></td>
                            <td class="p-2 border-b border-gray-200">Rp <?= number_format($commission['total_generated'] - ($commission['total_paid'] ?? 0), 0, ',', '.') ?></td>
                            <td class="p-2 border-b border-gray-200">
                                <form action="<?= base_url('payments/pay/' . $commission['affiliate_id']) ?>" method="POST" onsubmit="return confirm('Apakah Anda yakin ingin membayar komisi ini?');">
                                    <?= form_hidden($this->security->get_csrf_token_name(), $this->security->get_csrf_hash()); ?>
                                    <input type="hidden" name="affiliate_id" value="<?= htmlspecialchars($commission['affiliate_id']) ?>">
                                    <input type="hidden" name="amount" value="<?= htmlspecialchars($commission['total_generated'] - ($commission['total_paid'] ?? 0)) ?>">
                                    <button type="submit" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-1 px-3 rounded-full text-xs">Bayar</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
