<!-- Filee: application/views/dashboard/main.php -->
<div class="container-fluid">
    <?php if ($this->session->userdata('role_id') == 1): // Admin Dashboard ?>
    <div class="card p-4">
        <div class="card-header bg-white border-b border-gray-200 py-3">
            <h3 class="card-title text-xl font-semibold">Laporan Kinerja Afiliasi</h3>
        </div>
        <div class="card-body">
            <table id="affiliate-performance-table" class="display w-full text-sm">
                <thead>
                    <tr>
                        <th class="p-2 text-left text-gray-600 font-semibold">ID Afiliasi</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Username</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Kode Referral</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Total Penjualan</th>
                        <th class="p-2 text-right text-gray-600 font-semibold">Total Pendapatan</th>
                        <th class="p-2 text-right text-gray-600 font-semibold">Komisi Dihasilkan</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($affiliate_report as $affiliate): ?>
                        <tr class="hover:bg-gray-100">
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($affiliate['affiliate_id']) ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($affiliate['username']) ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($affiliate['referral_code']) ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($affiliate['total_sales']) ?></td>
                            <td class="p-2 border-b border-gray-200 text-right">Rp <?= number_format($affiliate['total_sales_amount'] ?? 0, 0, ',', '.') ?></td>
                            <td class="p-2 border-b border-gray-200 text-right">Rp <?= number_format($affiliate['total_commission_generated'] ?? 0, 0, ',', '.') ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>
    <?php if ($this->session->userdata('role_id') == 2): // Merchant Dashboard ?>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
        <div class="bg-white p-6 rounded-xl shadow-lg text-center">
            <div class="text-2xl font-bold text-gray-800">Rp 12.500.000</div>
            <div class="text-sm text-gray-500">Pendapatan Bulan Ini</div>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-lg text-center">
            <div class="text-2xl font-bold text-gray-800">150</div>
            <div class="text-sm text-gray-500">Total Produk</div>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-lg text-center">
            <div class="text-2xl font-bold text-gray-800">25</div>
            <div class="text-sm text-gray-500">Afiliasi Aktif</div>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-lg text-center">
            <div class="text-2xl font-bold text-gray-800">Rp 850.000</div>
            <div class="text-sm text-gray-500">Komisi Tertunda</div>
        </div>
    </div>
    <div class="card p-4 mb-6">
        <div class="card-header bg-white border-b border-gray-200 py-3">
            <h3 class="card-title text-xl font-semibold">Laporan Penjualan per Produk</h3>
        </div>
        <div class="card-body">
            <table id="sales-by-product-table" class="display w-full text-sm">
                <thead>
                    <tr>
                        <th class="p-2 text-left text-gray-600 font-semibold">Nama Produk</th>
                        <th class="p-2 text-right text-gray-600 font-semibold">Total Penjualan</th>
                        <th class="p-2 text-right text-gray-600 font-semibold">Total Pendapatan</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($sales_by_product as $item): ?>
                        <tr class="hover:bg-gray-100">
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($item['name']) ?></td>
                            <td class="p-2 border-b border-gray-200 text-right"><?= htmlspecialchars($item['total_sales']) ?></td>
                            <td class="p-2 border-b border-gray-200 text-right">Rp <?= number_format($item['total_revenue'] ?? 0, 0, ',', '.') ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    <div class="card p-4">
        <div class="card-header bg-white border-b border-gray-200 py-3">
            <h3 class="card-title text-xl font-semibold">Transaksi Terbaru</h3>
        </div>
        <div class="card-body">
            <table id="transactions-table" class="display w-full text-sm">
                <thead>
                    <tr>
                        <th class="p-2 text-left text-gray-600 font-semibold">ID Transaksi</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Pelanggan</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Produk</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Jumlah</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Tanggal</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($transactions as $transaction): ?>
                        <tr class="hover:bg-gray-100">
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($transaction['id']) ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($transaction['customer_name']) ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($transaction['product_name']) ?></td>
                            <td class="p-2 border-b border-gray-200">Rp <?= number_format($transaction['amount'], 0, ',', '.') ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($transaction['transaction_date']) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>
    <?php if ($this->session->userdata('role_id') == 3): // Affiliate Dashboard ?>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 mb-6">
        <div class="bg-white p-6 rounded-xl shadow-lg text-center">
            <div class="text-2xl font-bold text-gray-800">Rp <?= number_format($total_commission, 0, ',', '.') ?></div>
            <div class="text-sm text-gray-500">Total Komisi</div>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-lg text-center">
            <div class="text-2xl font-bold text-gray-800">Rp <?= number_format($paid_commission, 0, ',', '.') ?></div>
            <div class="text-sm text-gray-500">Komisi Dibayarkan</div>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-lg text-center">
            <div class="text-2xl font-bold text-gray-800">Rp <?= number_format($pending_commission, 0, ',', '.') ?></div>
            <div class="text-sm text-gray-500">Komisi Tertunda</div>
        </div>
    </div>
    <div class="card p-4">
        <div class="card-header bg-white border-b border-gray-200 py-3">
            <h3 class="card-title text-xl font-semibold">Penjualan Melalui Kode Referral Anda</h3>
        </div>
        <div class="card-body">
            <table id="affiliate-sales-table" class="display w-full text-sm">
                <thead>
                    <tr>
                        <th class="p-2 text-left text-gray-600 font-semibold">ID Transaksi</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Produk</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Pelanggan</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Jumlah Penjualan</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Komisi Anda</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Tanggal</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($affiliate_sales as $sale): ?>
                        <tr class="hover:bg-gray-100">
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($sale['id']) ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($sale['product_name']) ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($sale['customer_name']) ?></td>
                            <td class="p-2 border-b border-gray-200">Rp <?= number_format($sale['amount'], 0, ',', '.') ?></td>
                            <td class="p-2 border-b border-gray-200">Rp <?= number_format($sale['commission_amount'], 0, ',', '.') ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($sale['transaction_date']) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>
    <?php if ($this->session->userdata('role_id') == 4): // Customer Dashboard ?>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
        <div class="bg-white p-6 rounded-xl shadow-lg text-center">
            <div class="text-2xl font-bold text-gray-800">10</div>
            <div class="text-sm text-gray-500">Total Pembelian</div>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-lg text-center">
            <div class="text-2xl font-bold text-gray-800">Rp 18.000.000</div>
            <div class="text-sm text-gray-500">Total Belanja</div>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-lg text-center">
            <div class="text-2xl font-bold text-gray-800">3</div>
            <div class="text-sm text-gray-500">Merchant Favorit</div>
        </div>
        <div class="bg-white p-6 rounded-xl shadow-lg text-center">
            <div class="text-2xl font-bold text-gray-800">5</div>
            <div class="text-sm text-gray-500">Ulasan Dibuat</div>
        </div>
    </div>
    <div class="card p-4">
        <div class="card-header bg-white border-b border-gray-200 py-3">
            <h3 class="card-title text-xl font-semibold">Riwayat Pembelian</h3>
        </div>
        <div class="card-body">
            <p>Tabel riwayat pembelian akan ditampilkan di sini...</p>
        </div>
    </div>
    <?php endif; ?>
</div>
