<!-- Filee: application/views/checkout/index.php -->
<div class="container-fluid">
    <div class="card p-8 w-full md:w-2/3 mx-auto">
        <h2 class="text-2xl font-bold mb-4">Checkout Produk</h2>
        <div class="flex items-center space-x-4 mb-6 p-4 bg-gray-100 rounded-lg">
            <div class="flex-shrink-0">
                <i class="fas fa-shopping-bag text-4xl text-blue-500"></i>
            </div>
            <div>
                <h4 class="text-xl font-semibold"><?= htmlspecialchars($product->name) ?></h4>
                <p class="text-gray-600">Rp <?= number_format($product->price, 0, ',', '.') ?></p>
            </div>
        </div>
        <?= validation_errors('<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg relative mb-4">', '</div>'); ?>
        <?= form_open('checkout/process'); ?>
            <?= form_hidden($this->security->get_csrf_token_name(), $this->security->get_csrf_hash()); ?>
            <input type="hidden" name="product_id" value="<?= $product->id ?>">
            <div class="mb-4">
                <label for="referral_code" class="block text-gray-700 font-semibold mb-2">Kode Referral (Opsional)</label>
                <input type="text" name="referral_code" id="referral_code" class="w-full px-4 py-2 border rounded-md focus:outline-none focus:ring focus:ring-blue-200">
                <small class="text-gray-500">Jika Anda memiliki kode referral dari afiliasi, masukkan di sini.</small>
            </div>
            <button type="submit" class="w-full bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded-full transition-colors duration-300">Bayar Sekarang</button>
        <?= form_close(); ?>
    </div>
</div>
