<div class="container mx-auto px-4 py-8">
    <!-- Breadcrumb -->
    <nav class="flex mb-6" aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            <li class="inline-flex items-center">
                <a href="<?php echo base_url('catalog'); ?>" class="text-gray-700 hover:text-blue-600">Katalog</a>
            </li>
            <li>
                <div class="flex items-center">
                    <svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path></svg>
                    <a href="<?php echo base_url('catalog/category/' . $product->id_kategori); ?>" class="ml-1 text-gray-700 hover:text-blue-600 md:ml-2"><?php echo $product->nama_kategori; ?></a>
                </div>
            </li>
            <li aria-current="page">
                <div class="flex items-center">
                    <svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path></svg>
                    <span class="ml-1 text-gray-400 md:ml-2"><?php echo $product->nama_barang; ?></span>
                </div>
            </li>
        </ol>
    </nav>

    <div class="flex flex-col md:flex-row gap-8">
        <!-- Gallery Produk -->
        <div class="w-full md:w-1/2">
            <div class="sticky top-4">
                <div class="bg-white rounded-lg shadow-md p-4 mb-4">
                    <img src="<?php echo base_url('assets/images/products/' . ($product->gambar ?: 'default.jpg')); ?>" alt="<?php echo $product->nama_barang; ?>" class="w-full h-96 object-contain" id="mainImage">
                </div>
                
                <?php if ($images): ?>
                <div class="grid grid-cols-4 gap-2">
                    <div class="border rounded p-1 cursor-pointer" onclick="changeImage('<?php echo base_url('assets/images/products/' . ($product->gambar ?: 'default.jpg')); ?>')">
                        <img src="<?php echo base_url('assets/images/products/' . ($product->gambar ?: 'default.jpg')); ?>" alt="Thumbnail" class="w-full h-20 object-cover">
                    </div>
                    <?php foreach ($images as $image): ?>
                    <div class="border rounded p-1 cursor-pointer" onclick="changeImage('<?php echo base_url('assets/images/products/' . $image->gambar); ?>')">
                        <img src="<?php echo base_url('assets/images/products/' . $image->gambar); ?>" alt="Thumbnail" class="w-full h-20 object-cover">
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Info Produk -->
        <div class="w-full md:w-1/2">
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <h1 class="text-3xl font-bold mb-2"><?php echo $product->nama_barang; ?></h1>
                <p class="text-gray-600 mb-4">Oleh: <span class="text-blue-500"><?php echo $product->merchant_name; ?></span></p>
                
                <div class="flex items-center mb-4">
                    <div class="flex text-yellow-400 mr-2">
                        <?php for ($i = 1; $i <= 5; $i++): ?>
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                            <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                        </svg>
                        <?php endfor; ?>
                    </div>
                    <span class="text-gray-600">(42 ulasan)</span>
                </div>
                
                <div class="mb-6">
                    <span class="text-3xl font-bold text-blue-600">Rp <?php echo number_format($product->harga, 0, ',', '.'); ?></span>
                    <?php if ($product->komisi > 0): ?>
                    <span class="ml-3 bg-green-100 text-green-800 text-sm font-semibold px-2 py-1 rounded">Komisi <?php echo $product->komisi; ?>%</span>
                    <?php endif; ?>
                </div>
                
                <div class="mb-6">
                    <h3 class="font-semibold mb-2">Deskripsi Produk:</h3>
                    <p class="text-gray-700"><?php echo $product->deskripsi ?: 'Tidak ada deskripsi produk.'; ?></p>
                </div>
                
                <div class="mb-6">
                    <h3 class="font-semibold mb-2">Spesifikasi:</h3>
                    <ul class="list-disc list-inside text-gray-700">
                        <li>Berat: <?php echo $product->berat; ?> gram</li>
                        <li>Stok: <?php echo $product->stok > 0 ? $product->stok . ' tersedia' : 'Habis'; ?></li>
                        <li>Kategori: <?php echo $product->nama_kategori; ?></li>
                    </ul>
                </div>
                
                <div class="flex space-x-4 mb-6">
                    <div class="flex items-center">
                        <span class="mr-2">Jumlah:</span>
                        <div class="flex border rounded">
                            <button class="px-3 py-1 bg-gray-100">-</button>
                            <input type="text" value="1" class="w-12 text-center border-x">
                            <button class="px-3 py-1 bg-gray-100">+</button>
                        </div>
                    </div>
                    
                    <?php if ($product->stok > 0): ?>
                    <button class="flex-1 bg-blue-500 text-white py-2 px-4 rounded hover:bg-blue-600 transition duration-300">Beli Sekarang</button>
                    <button class="flex-1 bg-green-500 text-white py-2 px-4 rounded hover:bg-green-600 transition duration-300">Tambah ke Keranjang</button>
                    <?php else: ?>
                    <button class="flex-1 bg-gray-400 text-white py-2 px-4 rounded cursor-not-allowed" disabled>Stok Habis</button>
                    <?php endif; ?>
                </div>
                
                <!-- Affiliate Section -->
                <?php if (isset($affiliate_link)): ?>
                <div class="border-t pt-4 mt-4">
                    <h3 class="font-semibold mb-2">Link Affiliate:</h3>
                    <div class="flex">
                        <input type="text" value="<?php echo $affiliate_link; ?>" class="flex-1 border rounded-l p-2" id="affiliateLink" readonly>
                        <button onclick="copyAffiliateLink()" class="bg-blue-500 text-white px-4 rounded-r hover:bg-blue-600 transition duration-300">Salin</button>
                    </div>
                    <p class="text-sm text-gray-600 mt-2">Dapatkan komisi <?php echo $product->komisi; ?>% dari setiap penjualan melalui link ini</p>
                </div>
                <?php elseif ($this->session->userdata('logged_in')): ?>
                <div class="border-t pt-4 mt-4">
                    <button onclick="generateAffiliateLink(<?php echo $product->id_barang; ?>)" class="bg-purple-500 text-white py-2 px-4 rounded hover:bg-purple-600 transition duration-300">Generate Affiliate Link</button>
                </div>
                <?php else: ?>
                <div class="border-t pt-4 mt-4">
                    <p class="text-gray-600">Login sebagai affiliate untuk mendapatkan link komisi</p>
                    <a href="<?php echo base_url('auth/login'); ?>" class="inline-block mt-2 bg-purple-500 text-white py-2 px-4 rounded hover:bg-purple-600 transition duration-300">Login Affiliate</a>
                </div>
                <?php endif; ?>
            </div>
            
            <!-- Info Merchant -->
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <h3 class="font-semibold text-lg mb-4">Tentang Merchant</h3>
                <div class="flex items-center">
                    <div class="w-12 h-12 bg-gray-200 rounded-full flex items-center justify-center mr-4">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-gray-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                        </svg>
                    </div>
                    <div>
                        <h4 class="font-semibold"><?php echo $product->merchant_name; ?></h4>
                        <p class="text-gray-600 text-sm">Member sejak 2023</p>
                    </div>
                </div>
                <div class="mt-4 grid grid-cols-3 gap-4 text-center">
                    <div>
                        <p class="font-semibold">95%</p>
                        <p class="text-sm text-gray-600">Rating</p>
                    </div>
                    <div>
                        <p class="font-semibold">542</p>
                        <p class="text-sm text-gray-600">Produk</p>
                    </div>
                    <div>
                        <p class="font-semibold">2.5k</p>
                        <p class="text-sm text-gray-600">Penjualan</p>
                    </div>
                </div>
                <button class="w-full mt-4 bg-gray-100 text-gray-800 py-2 rounded hover:bg-gray-200 transition duration-300">Kunjungi Toko</button>
            </div>
        </div>
    </div>
    
    <!-- Produk Terkait -->
    <?php if ($related_products): ?>
    <div class="mt-12">
        <h2 class="text-2xl font-bold mb-6">Produk Terkait</h2>
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            <?php foreach ($related_products as $product): ?>
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition duration-300">
                <a href="<?php echo base_url('catalog/product/' . $product->id_barang); ?>">
                    <img src="<?php echo base_url('assets/images/products/' . ($product->gambar ?: 'default.jpg')); ?>" alt="<?php echo $product->nama_barang; ?>" class="w-full h-48 object-cover">
                </a>
                <div class="p-4">
                    <a href="<?php echo base_url('catalog/product/' . $product->id_barang); ?>" class="font-semibold text-lg hover:text-blue-500"><?php echo $product->nama_barang; ?></a>
                    <p class="text-gray-600 text-sm mt-1"><?php echo $product->merchant_name; ?></p>
                    <div class="flex justify-between items-center mt-3">
                        <span class="text-blue-600 font-bold">Rp <?php echo number_format($product->harga, 0, ',', '.'); ?></span>
                        <?php if ($product->komisi > 0): ?>
                        <span class="bg-green-100 text-green-800 text-xs font-semibold px-2 py-1 rounded">Komisi <?php echo $product->komisi; ?>%</span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endif; ?>
</div>

<script>
function changeImage(src) {
    document.getElementById('mainImage').src = src;
}

function copyAffiliateLink() {
    var copyText = document.getElementById("affiliateLink");
    copyText.select();
    copyText.setSelectionRange(0, 99999);
    document.execCommand("copy");
    alert("Link affiliate berhasil disalin: " + copyText.value);
}

function generateAffiliateLink(productId) {
    $.ajax({
        url: '<?php echo base_url("catalog/generate_affiliate_link_ajax"); ?>',
        method: 'POST',
        data: {product_id: productId},
        dataType: 'json',
        success: function(response) {
            if (response.status == 'success') {
                // Reload halaman untuk menampilkan link affiliate
                location.reload();
            } else {
                alert(response.message);
            }
        }
    });
}
</script>