<div class="container mx-auto px-4 py-8">
    <!-- Hero Section -->
    <div class="bg-gradient-to-r from-blue-500 to-purple-600 rounded-lg p-8 text-white mb-12">
        <h1 class="text-4xl font-bold mb-4">Temukan Produk Terbaik untuk Anda</h1>
        <p class="text-xl mb-6">Jelajahi ribuan produk dari merchant terpercaya dengan sistem affiliate yang menguntungkan</p>
        <a href="#categories" class="bg-white text-blue-600 px-6 py-3 rounded-lg font-semibold hover:bg-gray-100 transition duration-300">Jelajahi Kategori</a>
    </div>

    <!-- Kategori Section -->
    <section id="categories" class="mb-16">
        <h2 class="text-3xl font-bold mb-8 text-center">Kategori Produk</h2>
        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4">
            <?php foreach ($categories as $category): ?>
            <a href="<?php echo base_url('catalog/category/' . $category->id_kategori); ?>" class="bg-white rounded-lg shadow-md p-6 text-center hover:shadow-lg transition duration-300">
                <div class="bg-gray-100 rounded-full p-4 mb-4 mx-auto w-16 h-16 flex items-center justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-blue-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4" />
                    </svg>
                </div>
                <h3 class="font-semibold text-gray-800"><?php echo $category->nama_kategori; ?></h3>
            </a>
            <?php endforeach; ?>
        </div>
    </section>

    <!-- Produk Terbaru Section -->
    <section class="mb-16">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-bold">Produk Terbaru</h2>
            <a href="<?php echo base_url('catalog/category/1'); ?>" class="text-blue-500 hover:text-blue-700 font-semibold">Lihat Semua</a>
        </div>
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            <?php foreach ($new_products as $product): ?>
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition duration-300">
                <a href="<?php echo base_url('catalog/product/' . $product->id_barang); ?>">
                    <img src="<?php echo base_url('assets/images/products/' . ($product->gambar ?: 'default.jpg')); ?>" alt="<?php echo $product->nama_barang; ?>" class="w-full h-48 object-cover">
                </a>
                <div class="p-4">
                    <a href="<?php echo base_url('catalog/product/' . $product->id_barang); ?>" class="font-semibold text-lg hover:text-blue-500"><?php echo $product->nama_barang; ?></a>
                    <p class="text-gray-600 text-sm mt-1"><?php echo $product->komisi; ?></p>
                    <div class="flex justify-between items-center mt-3">
                        <span class="text-blue-600 font-bold">Rp <?php echo number_format($product->harga, 0, ',', '.'); ?></span>
                        <?php if ($product->komisi > 0): ?>
                        <span class="bg-green-100 text-green-800 text-xs font-semibold px-2 py-1 rounded">Komisi <?php echo $product->komisi; ?>%</span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </section>

    <!-- Produk Populer Section -->
    <section class="mb-16">
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-2xl font-bold">Produk Populer</h2>
            <a href="<?php echo base_url('catalog/category/2'); ?>" class="text-blue-500 hover:text-blue-700 font-semibold">Lihat Semua</a>
        </div>
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            <?php foreach ($popular_products as $product): ?>
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition duration-300">
                <a href="<?php echo base_url('catalog/product/' . $product->id_barang); ?>">
                    <img src="<?php echo base_url('assets/images/products/' . ($product->gambar ?: 'default.jpg')); ?>" alt="<?php echo $product->nama_barang; ?>" class="w-full h-48 object-cover">
                </a>
                <div class="p-4">
                    <a href="<?php echo base_url('catalog/product/' . $product->id_barang); ?>" class="font-semibold text-lg hover:text-blue-500"><?php echo $product->nama_barang; ?></a>
                    <p class="text-gray-600 text-sm mt-1"><?php echo $product->komisi; ?></p>
                    <div class="flex justify-between items-center mt-3">
                        <span class="text-blue-600 font-bold">Rp <?php echo number_format($product->harga, 0, ',', '.'); ?></span>
                        <?php if ($product->komisi > 0): ?>
                        <span class="bg-green-100 text-green-800 text-xs font-semibold px-2 py-1 rounded">Komisi <?php echo $product->komisi; ?>%</span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </section>
</div>