<div class="container mx-auto px-4 py-8">
    <div class="flex flex-col md:flex-row gap-8">
        <!-- Sidebar Kategori -->
        <div class="w-full md:w-1/4">
            <div class="bg-white rounded-lg shadow-md p-6 mb-6">
                <h3 class="font-bold text-lg mb-4">Kategori</h3>
                <ul>
                    <?php foreach ($categories as $category): ?>
                    <li class="mb-2">
                        <a href="<?php echo base_url('catalog/category/' . $category->id_kategori); ?>" class="text-gray-700 hover:text-blue-500 <?php echo $category_id == $category->id_kategori ? 'font-semibold text-blue-600' : ''; ?>">
                            <?php echo $category->nama_kategori; ?>
                        </a>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            
            <!-- Filter Section -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <h3 class="font-bold text-lg mb-4">Filter</h3>
                <div class="mb-4">
                    <h4 class="font-semibold mb-2">Harga</h4>
                    <div class="space-y-2">
                        <label class="flex items-center">
                            <input type="radio" name="price" class="mr-2"> Rp 0 - 100.000
                        </label>
                        <label class="flex items-center">
                            <input type="radio" name="price" class="mr-2"> Rp 100.000 - 500.000
                        </label>
                        <label class="flex items-center">
                            <input type="radio" name="price" class="mr-2"> Rp 500.000 - 1.000.000
                        </label>
                        <label class="flex items-center">
                            <input type="radio" name="price" class="mr-2"> > Rp 1.000.000
                        </label>
                    </div>
                </div>
                <div>
                    <h4 class="font-semibold mb-2">Komisi</h4>
                    <div class="space-y-2">
                        <label class="flex items-center">
                            <input type="checkbox" class="mr-2"> Tinggi (> 10%)
                        </label>
                        <label class="flex items-center">
                            <input type="checkbox" class="mr-2"> Sedang (5-10%)
                        </label>
                        <label class="flex items-center">
                            <input type="checkbox" class="mr-2"> Rendah (< 5%)
                        </label>
                    </div>
                </div>
                <button class="mt-4 w-full bg-blue-500 text-white py-2 rounded hover:bg-blue-600 transition duration-300">Terapkan Filter</button>
            </div>
        </div>
        
        <!-- Daftar Produk -->
        <div class="w-full md:w-3/4">
            <h1 class="text-3xl font-bold mb-6"><?php echo $current_category; ?></h1>
            
            <!-- Sorting dan Tampilan -->
            <div class="flex justify-between items-center mb-6 bg-white p-4 rounded-lg shadow-md">
                <p class="text-gray-600">Menampilkan <?php echo count($products); ?> produk</p>
                <div class="flex items-center space-x-4">
                    <span class="text-gray-600">Urutkan:</span>
                    <select class="border rounded p-2">
                        <option>Terbaru</option>
                        <option>Harga Tertinggi</option>
                        <option>Harga Terendah</option>
                        <option>Komisi Tertinggi</option>
                    </select>
                </div>
            </div>
            
            <!-- Grid Produk -->
            <?php if ($products): ?>
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
                <?php foreach ($products as $product): ?>
                <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition duration-300">
                    <a href="<?php echo base_url('catalog/product/' . $product->id_barang); ?>">
                        <img src="<?php echo base_url('assets/images/products/' . ($product->gambar ?: 'default.jpg')); ?>" alt="<?php echo $product->nama_barang; ?>" class="w-full h-48 object-cover">
                    </a>
                    <div class="p-4">
                        <a href="<?php echo base_url('catalog/product/' . $product->id_barang); ?>" class="font-semibold text-lg hover:text-blue-500"><?php echo $product->nama_barang; ?></a>
                        <p class="text-gray-600 text-sm mt-1"><?php echo $product->merchant_name; ?></p>
                        <div class="flex justify-between items-center mt-3">
                            <span class="text-blue-600 font-bold">Rp <?php echo number_format($product->harga, 0, ',', '.'); ?></span>
                            <?php if ($product->komisi > 0): ?>
                            <span class="bg-green-100 text-green-800 text-xs font-semibold px-2 py-1 rounded">Komisi <?php echo $product->komisi; ?>%</span>
                            <?php endif; ?>
                        </div>
                        <div class="mt-4">
                            <a href="<?php echo base_url('catalog/product/' . $product->id_barang); ?>" class="block w-full bg-blue-500 text-white text-center py-2 rounded hover:bg-blue-600 transition duration-300">Lihat Detail</a>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            
            <!-- Pagination -->
            <?php echo $pagination; ?>
            
            <?php else: ?>
            <div class="bg-white rounded-lg shadow-md p-8 text-center">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-16 w-16 mx-auto text-gray-400 mb-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.172 16.172a4 4 0 015.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <h3 class="text-xl font-semibold mb-2">Tidak ada produk</h3>
                <p class="text-gray-600">Belum ada produk dalam kategori ini.</p>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>