<!-- Filee: application/views/auth/register.php -->
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Registrasi - Marketplace</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
</head>
<body class="bg-gray-200 flex items-center justify-center min-h-screen">
    <div class="bg-white p-8 rounded-xl shadow-lg w-full max-w-md">
        <h2 class="text-2xl font-bold text-center mb-6">Registrasi Pengguna Baru</h2>
        <?= validation_errors('<div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg relative mb-4">', '</div>'); ?>
        <?= form_open('auth/register'); ?>
        <?= form_hidden($this->security->get_csrf_token_name(), $this->security->get_csrf_hash()); ?>
        <div class="mb-4">
            <label for="username" class="block text-gray-700 font-semibold mb-2">Username</label>
            <input type="text" name="username" id="username" class="w-full px-4 py-2 border rounded-md focus:outline-none focus:ring focus:ring-blue-200" value="<?= set_value('username'); ?>">
        </div>
        <div class="mb-4">
            <label for="email" class="block text-gray-700 font-semibold mb-2">Email</label>
            <input type="email" name="email" id="email" class="w-full px-4 py-2 border rounded-md focus:outline-none focus:ring focus:ring-blue-200" value="<?= set_value('email'); ?>">
        </div>
        <div class="mb-4">
            <label for="password" class="block text-gray-700 font-semibold mb-2">Password</label>
            <input type="password" name="password" id="password" class="w-full px-4 py-2 border rounded-md focus:outline-none focus:ring focus:ring-blue-200">
        </div>
        <div class="mb-6">
            <label for="role_id" class="block text-gray-700 font-semibold mb-2">Daftar Sebagai:</label>
            <select name="role_id" id="role_id" class="w-full px-4 py-2 border rounded-md focus:outline-none focus:ring focus:ring-blue-200">
                <option value="">Pilih Peran</option>
                <?php foreach ($roles as $role): ?>
                    <option value="<?= $role['id'] ?>" <?= set_select('role_id', $role['id']) ?>><?= $role['role_name'] ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <button type="submit" class="w-full bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded-full transition-colors duration-300">Daftar</button>
        <?= form_close(); ?>
    </div>
</body>
</html>
