<!-- Filee: application/views/accounting/profit_and_loss.php -->
<div class="container-fluid">
    <div class="card p-4">
        <div class="card-header bg-white border-b border-gray-200 py-3">
            <h3 class="card-title text-xl font-semibold">Laporan Laba Rugi</h3>
        </div>
        <div class="card-body">
            <h4 class="font-bold text-lg mb-2">Pendapatan</h4>
            <table class="table w-full mb-4 text-sm">
                <thead>
                    <tr>
                        <th class="p-2 text-left text-gray-600 font-semibold">Akun</th>
                        <th class="p-2 text-right text-gray-600 font-semibold">Jumlah</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($revenues as $name => $amount): ?>
                        <tr>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($name) ?></td>
                            <td class="p-2 border-b border-gray-200 text-right">Rp <?= number_format($amount, 0, ',', '.') ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
                <tfoot>
                    <tr class="font-bold">
                        <td class="p-2 text-gray-800">Total Pendapatan</td>
                        <td class="p-2 text-right text-gray-800">Rp <?= number_format($total_revenue, 0, ',', '.') ?></td>
                    </tr>
                </tfoot>
            </table>

            <h4 class="font-bold text-lg mb-2 mt-6">Beban</h4>
            <table class="table w-full mb-4 text-sm">
                <thead>
                    <tr>
                        <th class="p-2 text-left text-gray-600 font-semibold">Akun</th>
                        <th class="p-2 text-right text-gray-600 font-semibold">Jumlah</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($expenses as $name => $amount): ?>
                        <tr>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($name) ?></td>
                            <td class="p-2 border-b border-gray-200 text-right">Rp <?= number_format(abs($amount), 0, ',', '.') ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
                <tfoot>
                    <tr class="font-bold">
                        <td class="p-2 text-gray-800">Total Beban</td>
                        <td class="p-2 text-right text-gray-800">Rp <?= number_format(abs($total_expense), 0, ',', '.') ?></td>
                    </tr>
                </tfoot>
            </table>

            <div class="mt-6 p-4 bg-gray-100 rounded-xl">
                <h4 class="font-bold text-xl text-center">Laba Bersih</h4>
                <p class="text-4xl font-extrabold text-center mt-2 <?= ($net_profit >= 0) ? 'text-green-600' : 'text-red-600' ?>">
                    Rp <?= number_format($net_profit, 0, ',', '.') ?>
                </p>
            </div>
        </div>
    </div>
</div>
