<!-- Filee: application/views/accounting/general_ledger.php -->
<div class="container-fluid">
    <div class="card p-4">
        <div class="card-header bg-white border-b border-gray-200 py-3">
            <h3 class="card-title text-xl font-semibold">Buku Besar</h3>
        </div>
        <div class="card-body">
            <table id="journals-table" class="display w-full text-sm">
                <thead>
                    <tr>
                        <th class="p-2 text-left text-gray-600 font-semibold">Tanggal</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Deskripsi</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Akun Debet</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Akun Kredit</th>
                        <th class="p-2 text-right text-gray-600 font-semibold">Jumlah</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($journals as $journal): ?>
                        <tr class="hover:bg-gray-100">
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($journal['date']) ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($journal['description']) ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($journal['debit_account_name']) ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($journal['credit_account_name']) ?></td>
                            <td class="p-2 border-b border-gray-200 text-right">Rp <?= number_format($journal['amount'], 0, ',', '.') ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
