<!-- Filee: application/views/accounting/cash_flow.php -->
<div class="container-fluid">
    <div class="card p-4">
        <div class="card-header bg-white border-b border-gray-200 py-3">
            <h3 class="card-title text-xl font-semibold">Laporan Arus Kas</h3>
        </div>
        <div class="card-body">
            <table id="cash-flow-table" class="display w-full text-sm">
                <thead>
                    <tr>
                        <th class="p-2 text-left text-gray-600 font-semibold">Tanggal</th>
                        <th class="p-2 text-left text-gray-600 font-semibold">Deskripsi</th>
                        <th class="p-2 text-right text-gray-600 font-semibold">Kas Masuk (Debit)</th>
                        <th class="p-2 text-right text-gray-600 font-semibold">Kas Keluar (Kredit)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                        $balance = 0;
                        foreach ($cash_flow as $item): 
                            $kas_masuk = ($item['debit_account'] == 'Kas') ? $item['amount'] : 0;
                            $kas_keluar = ($item['credit_account'] == 'Kas') ? $item['amount'] : 0;
                            $balance += $kas_masuk - $kas_keluar;
                    ?>
                        <tr class="hover:bg-gray-100">
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($item['date']) ?></td>
                            <td class="p-2 border-b border-gray-200"><?= htmlspecialchars($item['description']) ?></td>
                            <td class="p-2 border-b border-gray-200 text-right">Rp <?= number_format($kas_masuk, 0, ',', '.') ?></td>
                            <td class="p-2 border-b border-gray-200 text-right">Rp <?= number_format($kas_keluar, 0, ',', '.') ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
                <tfoot>
                    <tr class="font-bold">
                        <td colspan="3" class="p-2 text-right text-gray-800">Saldo Akhir Kas</td>
                        <td class="p-2 text-right text-gray-800">Rp <?= number_format($balance, 0, ',', '.') ?></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
