<?php
// File: application/models/User_model.php
// Model ini menangani logika otentikasi dan RBAC.

class User_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    /**
     * Memeriksa kredensial login.
     *
     * @param string $username
     * @param string $password
     * @return object|bool Objek pengguna jika berhasil, False jika gagal.
     */
    public function login($username, $password) {
        $user = $this->db->get_where('tbl_user', ['username' => $username])->row();
        
        // Menggunakan password_verify untuk keamanan
        if ($user && password_verify($password, $user->password)) {
            return $user;
        }
        return false;
    }

    /**
     * Mendaftarkan pengguna baru.
     *
     * @param array $data
     * @return bool
     */
    public function register($data) {
        // Enkripsi password sebelum disimpan
        $data['password'] = password_hash($data['password'], PASSWORD_DEFAULT);
        return $this->db->insert('users', $data);
    }
    
    /**
     * Mengambil peran pengguna.
     * @param int $user_id
     * @return object
     */
    public function get_user_role($user_id) {
        return $this->db->get_where('users', ['id' => $user_id])->row();
    }

    /**
     * Memeriksa apakah pengguna memiliki izin tertentu.
     * Metode ini adalah inti dari sistem RBAC.
     *
     * @param string $permission_slug Slug dari izin yang diperlukan.
     * @return bool True jika pengguna memiliki izin, False jika tidak.
     */
    public function check_permission($permission_slug) {
        $user_id = $this->session->userdata('user_id');

        if (!$user_id) {
            return false;
        }

        $this->db->select('rp.permission_id');
        $this->db->from('role_permissions rp');
        $this->db->join('permissions p', 'p.id = rp.permission_id');
        $this->db->where('rp.role_id', $this->session->userdata('role_id'));
        $this->db->where('p.permission_slug', $permission_slug);
        $query = $this->db->get();

        return ($query->num_rows() > 0);
    }
}
