<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Product_model extends CI_Model {
    
    public function __construct() {
        parent::__construct();
        $this->load->database();
    }
    
    // Ambil semua kategori
    public function get_categories() {
        $this->db->order_by('nama_kategori', 'ASC');
        return $this->db->get('tbl_kategori')->result();
    }
    
    // Ambil produk berdasarkan kategori
    public function get_products_by_category($category_id, $limit = 12, $offset = 0) {
        $this->db->select('tbl_barang.*, tbl_kategori.nama_kategori, tbl_user.nama_user as merchant_name');
        $this->db->from('tbl_barang');
        $this->db->join('tbl_kategori', 'tbl_barang.id_kategori = tbl_kategori.id_kategori');
        $this->db->join('tbl_user', 'tbl_barang.id_user = tbl_user.id_user');
        $this->db->where('tbl_barang.id_kategori', $category_id);
        $this->db->where('tbl_barang.status_barang', 'live');
        $this->db->where('tbl_barang.is_active', 1);
        $this->db->order_by('tbl_barang.created_at', 'DESC');
        $this->db->limit($limit, $offset);
        
        return $this->db->get()->result();
    }
    
    // Hitung total produk per kategori
    public function count_products_by_category($category_id) {
        $this->db->where('id_kategori', $category_id);
        $this->db->where('status_barang', 'live');
        $this->db->where('is_active', 1);
        return $this->db->count_all_results('tbl_barang');
    }
    
    // Ambil detail produk
    public function get_product_detail($product_id) {
        $this->db->select('tbl_barang.*, tbl_kategori.nama_kategori, tbl_user.nama_user as merchant_name, tbl_user.affiliate_code');
        $this->db->from('tbl_barang');
        $this->db->join('tbl_kategori', 'tbl_barang.id_kategori = tbl_kategori.id_kategori');
        $this->db->join('tbl_user', 'tbl_barang.id_user = tbl_user.id_user');
        $this->db->where('tbl_barang.id_barang', $product_id);
        $this->db->where('tbl_barang.status_barang', 'live');
        $this->db->where('tbl_barang.is_active', 1);
        
        return $this->db->get()->row();
    }
    
    // Ambil gambar produk
    public function get_product_images($product_id) {
        $this->db->where('id_barang', $product_id);
        return $this->db->get('tbl_gambar')->result();
    }
    
    // Ambil produk terkait
    public function get_related_products($category_id, $product_id, $limit = 4) {
        $this->db->where('id_kategori', $category_id);
        $this->db->where('id_barang !=', $product_id);
        $this->db->where('status_barang', 'live');
        $this->db->where('is_active', 1);
        $this->db->order_by('RAND()');
        $this->db->limit($limit);
        
        return $this->db->get('tbl_barang')->result();
    }
    
    // Ambil produk terbaru
    public function get_new_products($limit = 8) {
        $this->db->where('status_barang', 'live');
        $this->db->where('is_active', 1);
        $this->db->order_by('created_at', 'DESC');
        $this->db->limit($limit);
        
        return $this->db->get('tbl_barang')->result();
    }
    
    // Ambil produk populer (berdasarkan penjualan)
    public function get_popular_products($limit = 8) {
        $this->db->select('tbl_barang.*, COUNT(tbl_rinci_transaksi.id_rinci) as total_sold');
        $this->db->from('tbl_barang');
        $this->db->join('tbl_rinci_transaksi', 'tbl_barang.id_barang = tbl_rinci_transaksi.id_barang', 'left');
        $this->db->where('tbl_barang.status_barang', 'live');
        $this->db->where('tbl_barang.is_active', 1);
        $this->db->group_by('tbl_barang.id_barang');
        $this->db->order_by('total_sold', 'DESC');
        $this->db->limit($limit);
        
        return $this->db->get()->result();
    }
    
    // Generate affiliate link
    public function generate_affiliate_link($product_id, $affiliate_code) {
        $product = $this->get_product_detail($product_id);
        
        if ($product) {
            $base_url = base_url();
            $slug = $product->slug;
            
            return $base_url . 'ref/' . $affiliate_code . '/' . $slug;
        }
        
        return false;
    }
    
    // Simpan affiliate link
    public function save_affiliate_link($data) {
        return $this->db->insert('tbl_affiliate_links', $data);
    }
}