<?php
// File: application/models/Notification_model.php
// Model baru untuk notifikasi in-app.

class Notification_model extends CI_Model {
    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    /**
     * Menciptakan notifikasi baru untuk pengguna.
     * @param int $user_id
     * @param string $message
     * @return bool
     */
    public function create_notification($user_id, $message) {
        $data = [
            'user_id' => $user_id,
            'message' => $message,
            'is_read' => 0
        ];
        return $this->db->insert('notifications', $data);
    }

    /**
     * Mendapatkan notifikasi yang belum dibaca untuk pengguna.
     * @param int $user_id
     * @return array
     */
    public function get_unread_notifications($user_id) {
        $this->db->where('user_id', $user_id);
        $this->db->where('is_read', 0);
        $this->db->order_by('created_at', 'DESC');
        return $this->db->get('notifications')->result_array();
    }

    /**
     * Mendapatkan semua notifikasi untuk pengguna.
     * @param int $user_id
     * @return array
     */
    public function get_all_notifications($user_id) {
        $this->db->where('user_id', $user_id);
        $this->db->order_by('created_at', 'DESC');
        return $this->db->get('notifications')->result_array();
    }

    /**
     * Menandai notifikasi sebagai sudah dibaca.
     * @param int $notification_id
     * @return bool
     */
    public function mark_as_read($notification_id) {
        $data = ['is_read' => 1];
        return $this->db->update('notifications', $data, ['id' => $notification_id]);
    }
}
