<?php
// File: application/models/Barang_model.php (Model Baru)
// Model ini bertanggung jawab untuk interaksi dengan tabel `tbl_barang` dan relasinya.

defined('BASEPATH') OR exit('No direct script access allowed');

class Barang_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    /**
     * Mengambil semua data barang yang aktif untuk ditampilkan di katalog.
     * @return array
     */
    public function get_all_barang() {
        $this->db->select('id_barang, nama_barang, harga, gambar, slug');
        $this->db->from('tbl_barang');
        $this->db->where('status_barang', 'live');
        $this->db->where('is_active', 1);
        $query = $this->db->get();
        return $query->result();
    }

    /**
     * Mengambil detail satu barang beserta data SEO dari tbl_landingpage.
     * @param string $slug
     * @return object
     */
    public function get_barang_by_slug($slug) {
        $this->db->select('b.*, l.judul_seo, l.deskripsi_seo, l.keyword_seo');
        $this->db->from('tbl_barang as b');
        $this->db->join('tbl_landingpage as l', 'b.id_barang = l.id_barang', 'left');
        $this->db->where('b.slug', $slug);
        $this->db->where('b.status_barang', 'live');
        $this->db->where('b.is_active', 1);
        $query = $this->db->get();
        return $query->row();
    }
}
