<?php
// File: application/models/Affiliate_model.php
// Model baru untuk data afiliasi.

class Affiliate_model extends CI_Model {
    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    /**
     * Mendapatkan total komisi yang dihasilkan oleh afiliasi.
     * @param int $affiliate_id
     * @return float
     */
    public function get_total_commission($affiliate_id) {
        $this->db->select('SUM(commission_amount) as total_commission');
        $this->db->from('transactions');
        $this->db->where('affiliate_id', $affiliate_id);
        $result = $this->db->get()->row();
        return $result->total_commission ? $result->total_commission : 0;
    }

    /**
     * Mendapatkan total komisi yang sudah dibayarkan kepada afiliasi.
     * @param int $affiliate_id
     * @return float
     */
    public function get_paid_commission($affiliate_id) {
        $this->db->select('SUM(amount) as paid_amount');
        $this->db->from('payments');
        $this->db->where('affiliate_id', $affiliate_id);
        $result = $this->db->get()->row();
        return $result->paid_amount ? $result->paid_amount : 0;
    }

    /**
     * Mendapatkan semua komisi yang belum dibayarkan per afiliasi.
     * Ini digunakan untuk modul pembayaran admin.
     * @return array
     */
    public function get_pending_commissions() {
        $this->db->select('a.id as affiliate_id, u.username, SUM(t.commission_amount) as total_generated, SUM(p.amount) as total_paid');
        $this->db->from('affiliates a');
        $this->db->join('users u', 'u.id = a.user_id');
        $this->db->join('transactions t', 't.affiliate_id = a.id', 'left');
        $this->db->join('payments p', 'p.affiliate_id = a.id', 'left');
        $this->db->group_by('a.id');
        $this->db->having('SUM(t.commission_amount) > SUM(p.amount) OR SUM(p.amount) IS NULL');
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
     * Mendapatkan laporan kinerja afiliasi.
     * @return array
     */
    public function get_affiliate_performance_report() {
        $this->db->select('a.id as affiliate_id, u.username, a.kode_referral, COUNT(t.id) as total_sales, SUM(t.amount) as total_sales_amount, SUM(t.commission_amount) as total_commission_generated');
        $this->db->from('affiliates a');
        $this->db->join('tbl_user u', 'u.id_user = a.id');
        $this->db->join('transactions t', 't.affiliate_id = a.id', 'left');
        $this->db->group_by('a.id, u.username, a.kode_referral');
        $this->db->order_by('total_sales', 'DESC');
        $query = $this->db->get();
        return $query->result_array();
    }
}
