<?php
// File: application/models/Accounting_model.php
// Model baru untuk modul akuntansi.

class Accounting_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    /**
     * Mengambil semua entri jurnal dari database.
     * @return array
     */
    public function get_all_journal_entries() {
        $this->db->select('j.*, d.account_name as debit_account_name, c.account_name as credit_account_name');
        $this->db->from('journals j');
        $this->db->join('account_master d', 'd.id = j.debit_account_id');
        $this->db->join('account_master c', 'c.id = j.credit_account_id');
        $this->db->order_by('j.date', 'ASC');
        $query = $this->db->get();
        return $query->result_array();
    }

    /**
     * Mendapatkan saldo akun untuk laporan laba rugi.
     * @return array
     */
    public function get_profit_and_loss_data() {
        // Ambil semua akun pendapatan dan beban
        $this->db->select('*');
        $this->db->where_in('account_type', ['Revenue', 'Expense']);
        $accounts = $this->db->get('account_master')->result_array();

        $account_balances = [];
        foreach ($accounts as $account) {
            $account_balances[$account['account_name']] = 0;
            // Hitung total debit dan kredit untuk setiap akun
            $this->db->select('SUM(amount) as total_debit');
            $this->db->where('debit_account_id', $account['id']);
            $debit_result = $this->db->get('journals')->row()->total_debit;

            $this->db->select('SUM(amount) as total_credit');
            $this->db->where('credit_account_id', $account['id']);
            $credit_result = $this->db->get('journals')->row()->total_credit;

            $debit_result = $debit_result ? $debit_result : 0;
            $credit_result = $credit_result ? $credit_result : 0;
            
            // Hitung saldo akhir
            $account_balances[$account['account_name']] = $credit_result - $debit_result;
        }

        return $account_balances;
    }
    
    /**
     * Mendapatkan laporan arus kas.
     * @return array
     */
    public function get_cash_flow_report() {
        $this->db->select('j.date, j.description, j.amount, d.account_name as debit_account, c.account_name as credit_account');
        $this->db->from('journals j');
        $this->db->join('account_master d', 'd.id = j.debit_account_id');
        $this->db->join('account_master c', 'c.id = j.credit_account_id');
        $this->db->where_in('j.debit_account_id', [1, 2]); // Kas, Piutang Usaha
        $this->db->or_where_in('j.credit_account_id', [1, 2]); // Kas, Piutang Usaha
        $this->db->order_by('j.date', 'ASC');
        $query = $this->db->get();
        return $query->result_array();
    }
}
