<?php
// =========================================================================
// Bagian 2: File CodeIgniter 3
// Letakkan file-file ini di direktori yang sesuai.
// =========================================================================
// Fileee: application/core/MY_Controller.php
// Controller dasar yang menangani otentikasi dan hak akses.
// Letakkan file ini di direktori `application/core`.
#[\AllowDynamicProperties]
class MY_Controller extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        $this->load->helper('url');
        $this->load->model(['User_model', 'Notification_model']);
        
        // Memeriksa apakah pengguna sudah login
        if (!$this->session->userdata('is_logged_in')) {
            // Jika tidak, arahkan ke halaman login, kecuali jika halaman yang diminta adalah login atau register
            if ($this->uri->segment(1) !== 'auth') {
                redirect('auth/login');
            }
        }
    }

    /**
     * Metode untuk memeriksa hak akses berdasarkan permission slug.
     *
     * @param string $permission_slug Slug dari izin yang diperlukan.
     */
    protected function check_permission($permission_slug) {
        if (!$this->User_model->check_permission($permission_slug)) {
            show_error('Anda tidak memiliki izin untuk mengakses halaman ini.', 403);
            exit;
        }
    }
}