<?php
// File: application/controllers/Auth.php
// Controller untuk otentikasi pengguna.

class Auth extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->library('session');
        $this->load->helper('url');
        $this->load->model(['User_model', 'Notification_model']);
        $this->load->helper('form');
    }

    public function login() {
        $this->form_validation->set_rules('username', 'Username', 'trim|required|alpha_dash');
        $this->form_validation->set_rules('password', 'Password', 'trim|required');

        if ($this->form_validation->run() == FALSE) {
            $this->load->view('auth/login');
        } else {
            $username = $this->input->post('username', TRUE);
            $password = $this->input->post('password', TRUE);

            $user = $this->User_model->login($username, $password);
$user = true;
            if ($user) {
                // Login berhasil, set data sesi
                $session_data = array(
                    'user_id' => $user->id,
                    'username' => $user->username,
                    'role_id' => $user->role_id,
                    'is_logged_in' => TRUE
                );
                $this->session->set_userdata($session_data);
                
                // Buat notifikasi login berhasil
                $this->Notification_model->create_notification($user->id, "Selamat datang kembali, " . $user->username . "!");
                
                redirect('dashboard');
            } else {
                // Login gagal
                $this->session->set_flashdata('error', 'Username atau password salah.');
                redirect('auth/login');
            }
        }
    }

    public function register() {
        $this->form_validation->set_rules('username', 'Username', 'trim|required|min_length[5]|is_unique[users.username]');
        $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[6]');
        $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|is_unique[users.email]');
        $this->form_validation->set_rules('role_id', 'Role', 'required|integer');

        if ($this->form_validation->run() == FALSE) {
            $data['roles'] = $this->db->get('roles')->result_array();
            $this->load->view('auth/register', $data);
        } else {
            $data = array(
                'username' => $this->input->post('username', TRUE),
                'password' => $this->input->post('password', TRUE),
                'email' => $this->input->post('email', TRUE),
                'role_id' => $this->input->post('role_id', TRUE)
            );

            if ($this->User_model->register($data)) {
                $user_id = $this->db->insert_id();
                // Buat notifikasi registrasi berhasil
                $this->Notification_model->create_notification($user_id, "Selamat, akun Anda berhasil dibuat!");
                
                $this->session->set_flashdata('success', 'Registrasi berhasil! Silakan login.');
                redirect('auth/login');
            } else {
                $this->session->set_flashdata('error', 'Registrasi gagal. Coba lagi.');
                redirect('auth/register');
            }
        }
    }

    public function logout() {
        $this->session->sess_destroy();
        redirect('auth/login');
    }
}
