<?php
// File: application/controllers/Produk.php (Controller Baru)
// Controller ini menangani semua halaman yang dapat diakses publik terkait produk.

defined('BASEPATH') OR exit('No direct script access allowed');

class Produk extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Barang_model');
        $this->load->helper('url');
    }

    /**
     * Menampilkan halaman katalog semua produk.
     */
    public function index() {
        $data['title'] = "Katalog Produk Kami";
        $data['meta_description'] = "Jelajahi berbagai produk unggulan kami dengan penawaran terbaik.";
        $data['barang_list'] = $this->Barang_model->get_all_barang();

        $this->load->view('templates/public_header', $data);
        $this->load->view('produk/index', $data);
        $this->load->view('templates/public_footer', $data);
    }

    /**
     * Menampilkan halaman detail produk berdasarkan slug.
     * URL: domain.com/produk/nama-produk-yang-seo-friendly
     * @param string $slug Slug dari tbl_barang atau tbl_landingpage.
     */
    public function detail($slug) {
        $barang = $this->Barang_model->get_barang_by_slug($slug);

        if (empty($barang)) {
            show_404();
        }

        // Mengambil data SEO dari tbl_landingpage jika ada, jika tidak, gunakan data dari tbl_barang
        $data['title'] = !empty($barang->judul_seo) ? $barang->judul_seo : htmlspecialchars($barang->nama_barang);
        $data['meta_description'] = !empty($barang->deskripsi_seo) ? strip_tags($barang->deskripsi_seo) : substr(strip_tags($barang->deskripsi), 0, 160);
        $data['meta_keywords'] = !empty($barang->keyword_seo) ? $barang->keyword_seo : $barang->keyword;

        $data['barang'] = $barang;

        $this->load->view('templates/public_header', $data);
        $this->load->view('produk/detail', $data);
        $this->load->view('templates/public_footer', $data);
    }
}
