<?php
// File: application/controllers/Payments.php
// Controller baru untuk pembayaran komisi.

class Payments extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->check_permission('manage_payments'); // Hanya untuk Admin/Merchant
        $this->load->model(['Affiliate_model', 'Accounting_model', 'Notification_model']);
        $this->load->helper(['url', 'form']);
        $this->load->library('form_validation');
    }

    public function index() {
        $data['title'] = "Pembayaran Komisi";
        $data['commissions'] = $this->Affiliate_model->get_pending_commissions();

        $this->load->view('templates/header', $data);
        $this->load->view('payments/index', $data);
        $this->load->view('templates/footer', $data);
    }

    /**
     * Memproses pembayaran komisi.
     * Metode ini harus dipanggil via POST dari form.
     */
    public function pay($affiliate_id) {
        $this->form_validation->set_rules('amount', 'Jumlah', 'trim|required|numeric|greater_than[0]');
        $this->form_validation->set_rules('affiliate_id', 'ID Afiliasi', 'trim|required|integer');

        if ($this->form_validation->run() == FALSE) {
            $this->session->set_flashdata('error', 'Jumlah pembayaran tidak valid.');
            redirect('payments');
        }

        $amount_to_pay = $this->input->post('amount', TRUE);
        $affiliate_id = $this->input->post('affiliate_id', TRUE);
        
        $this->db->trans_start();
        
        // 1. Catat pembayaran di tabel `payments`
        $payment_data = [
            'affiliate_id' => $affiliate_id,
            'amount' => $amount_to_pay
        ];
        $this->db->insert('payments', $payment_data);
        $payment_id = $this->db->insert_id();

        // 2. Buat entri jurnal ganda
        $journal_entry = [
            'payment_id' => $payment_id,
            'date' => date('Y-m-d'),
            'description' => 'Pembayaran komisi kepada afiliasi ID ' . $affiliate_id,
            'debit_account_id' => 3,
            'credit_account_id' => 1,
            'amount' => $amount_to_pay
        ];
        $this->db->insert('journals', $journal_entry);
        
        // 3. Buat notifikasi untuk afiliasi
        $affiliate_user = $this->db->get_where('affiliates', ['id' => $affiliate_id])->row();
        if ($affiliate_user) {
            $this->Notification_model->create_notification($affiliate_user->user_id, "Komisi Anda sebesar Rp " . number_format($amount_to_pay, 0, ',', '.') . " telah dibayarkan.");
        }

        $this->db->trans_complete();

        if ($this->db->trans_status() === FALSE) {
            $this->session->set_flashdata('error', 'Gagal memproses pembayaran. Silakan coba lagi.');
        } else {
            $this->session->set_flashdata('success', 'Pembayaran berhasil dicatat.');
        }

        redirect('payments');
    }
}
