<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Home extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->load->model('m_home');
	}

	public function index()
	{
		$data = array(
			'title' => 'Sekawan Berkah',
			'barang' => $this->m_home->get_all_data(),
			'isi' => 'v_home',
		);
		$this->load->view('layout/v_wrapper_frontend', $data, FALSE);
	}

	// public function datatoko()
	// {
	// 	$data = array(
	// 		'setting' => $this->m_home->get_data_toko(),
	// 		'isi' => 'v_nav_frontend',
	// 	);
	// 	$this->load->view('layout/v_wrapper_frontend', $data, FALSE);
	// }

	public function kategori($id_kategori)
	{
		$kategori = $this->m_home->kategori($id_kategori);
		$data = array(
			'title' => 'Niche : ' . $kategori->nama_kategori,
			'barang' => $this->m_home->get_all_data_barang($id_kategori),
			'isi' => 'v_kategori_barang',
		);
		$this->load->view('layout/v_wrapper_frontend', $data, FALSE);
	}

	public function niche($id_barang, $reff = null )
	{
	    $this->session->set_userdata('user_reference', $reff);
	    $barang = $this->m_home->niche($id_barang);
	    if (!$barang) {
     // list is empty.
} else {
		$data = array(
			'title' => $barang->nama_barang,
			'gambar' => $this->m_home->gambar_barang($id_barang),
			'barang' => $this->m_home->niche($id_barang),
			'nama_ref'=> $reff,
			'isi' => 'v_detail_barang',
		);
		$this->load->view('layout/v_wrapper_frontend', $data, FALSE);}
	}
}

/* End of file Home.php */
