<?php
// File: application/controllers/Dashboard.php
/* Controller untuk Dasbor.

class Dashboard extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->library('session');
        $this->load->helper('url');
//        $this->load->model(['User_model', 'Notification_model']);
        $this->load->model(['User_model', 'Transaction_model', 'Affiliate_model', 'Product_model', 'Notification_model']);
        $this->load->helper('form');
    }
*/
 
//class Dashboard extends CI_Controller {
class Dashboard extends MY_Controller {
    public function __construct() {
        parent::__construct();
        $this->check_permission('view_dashboard');
        $this->load->model(['User_model', 'Transaction_model', 'Affiliate_model', 'Product_model', 'Notification_model']);
    }


    public function index() {
        $user_role_id = 2 ;
        $this->session->userdata('role_id');
        $user_id = $this->session->userdata('user_id');

        $data['title'] = "Dasbor";

        switch ($user_role_id) {
            case 1: // Admin
                $data['title'] = "Dasbor Admin";
                $data['affiliate_report'] = $this->Affiliate_model->get_affiliate_performance_report();
                break;
            case 2: // Merchant
                $data['title'] = "Dasbor Merchant";
                $data['transactions'] = $this->Transaction_model->get_recent_transactions($user_id);
                $data['sales_by_product'] = $this->Transaction_model->get_sales_by_product($user_id);
                break;
            case 3: // Affiliate
                $data['title'] = "Dasbor Afiliasi";
                $affiliate = $this->db->get_where('affiliates', ['user_id' => $user_id])->row();
                if ($affiliate) {
                    $data['total_commission'] = $this->Affiliate_model->get_total_commission($affiliate->id);
                    $data['paid_commission'] = $this->Affiliate_model->get_paid_commission($affiliate->id);
                    $data['pending_commission'] = $data['total_commission'] - $data['paid_commission'];
                    
                    // Mendapatkan penjualan afiliasi
                    $this->db->select('t.*, p.name as product_name, u.username as customer_name');
                    $this->db->from('transactions t');
                    $this->db->join('products p', 'p.id = t.product_id');
                    $this->db->join('users u', 'u.id = t.customer_id');
                    $this->db->where('t.affiliate_id', $affiliate->id);
                    $data['affiliate_sales'] = $this->db->get()->result_array();
                } else {
                    $data['total_commission'] = 0;
                    $data['paid_commission'] = 0;
                    $data['pending_commission'] = 0;
                    $data['affiliate_sales'] = [];
                }
                break;
            default: // Customer
                $data['title'] = "Dasbor Pelanggan";
                // Data khusus pelanggan
                break;
        }

        $this->load->view('templates/header', $data);
        $this->load->view('dashboard/main', $data);
        $this->load->view('templates/footer', $data);
    }

    public function get_notifications() {
        $user_id = $this->session->userdata('user_id');
        $notifications = $this->Notification_model->get_unread_notifications($user_id);
        
        header('Content-Type: application/json');
        echo json_encode(['count' => count($notifications), 'notifications' => $notifications]);
    }
}
