<?php
// File: application/controllers/Checkout.php
// Controller baru untuk proses checkout.

class Checkout extends MY_Controller {

    public function __construct() {
        parent::__construct();
        // Hanya Customer yang bisa checkout
        if ($this->session->userdata('role_id') != 4) {
            show_error('Anda tidak memiliki izin untuk mengakses halaman ini.', 403);
            exit;
        }
        $this->load->model(['Transaction_model', 'Notification_model']);
        $this->load->library('form_validation');
        $this->load->helper('form');
    }

    public function index($product_id) {
        $product_id = intval($product_id);
        $data['product'] = $this->Transaction_model->get_product_by_id($product_id);

        if (!$data['product']) {
            show_error('Produk tidak ditemukan.', 404);
            exit;
        }
        
        $data['title'] = "Checkout: " . $data['product']->name;

        $this->load->view('templates/header', $data);
        $this->load->view('checkout/index', $data);
        $this->load->view('templates/footer', $data);
    }

    public function process() {
        $this->form_validation->set_rules('product_id', 'Product ID', 'trim|required|integer');
        $this->form_validation->set_rules('referral_code', 'Kode Referral', 'trim');

        if ($this->form_validation->run() == FALSE) {
            $product_id = $this->input->post('product_id', TRUE);
            $this->index($product_id);
            return;
        }

        $product_id = $this->input->post('product_id', TRUE);
        $referral_code = $this->input->post('referral_code', TRUE);

        $product = $this->Transaction_model->get_product_by_id($product_id);
        $affiliate = NULL;
        $commission_amount = 0;

        if ($referral_code) {
            $affiliate = $this->Transaction_model->get_affiliate_by_code($referral_code);
            if ($affiliate) {
                $commission_amount = $product->price * ($product->affiliate_commission_rate / 100);
            }
        }

        $transaction_data = [
            'customer_id' => $this->session->userdata('user_id'),
            'product_id' => $product->id,
            'merchant_id' => $product->merchant_id,
            'affiliate_id' => $affiliate ? $affiliate->id : NULL,
            'amount' => $product->price,
            'commission_amount' => $commission_amount
        ];

        if ($this->Transaction_model->process_checkout($transaction_data)) {
            // Buat notifikasi untuk pelanggan
            $this->Notification_model->create_notification($this->session->userdata('user_id'), "Transaksi Anda untuk " . $product->name . " berhasil!");

            $this->session->set_flashdata('success', 'Pembelian berhasil! Terima kasih telah berbelanja.');
        } else {
            $this->session->set_flashdata('error', 'Gagal memproses pembelian. Silakan coba lagi.');
        }

        redirect('dashboard');
    }
}
