<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Catalog extends CI_Controller {
    
    public function __construct() {
        parent::__construct();
        $this->load->model('Product_model');
        $this->load->library('pagination');
        $this->load->helper('url');
    }
    
    // Halaman utama katalog
    public function index() {
        $data['categories'] = $this->Product_model->get_categories();
        $data['new_products'] = $this->Product_model->get_new_products();
        $data['popular_products'] = $this->Product_model->get_popular_products();
        
        $this->load->view('templates/public_header');
        $this->load->view('catalog/index', $data);
        $this->load->view('templates/footer');
    }
    
    // Halaman kategori
    public function category($category_id) {
        // Konfigurasi pagination
        $config['base_url'] = base_url('catalog/category/' . $category_id);
        $config['total_rows'] = $this->Product_model->count_products_by_category($category_id);
        $config['per_page'] = 12;
        $config['uri_segment'] = 4;
        
        $this->pagination->initialize($config);
        
        $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        
        $data['products'] = $this->Product_model->get_products_by_category($category_id, $config['per_page'], $page);
        $data['categories'] = $this->Product_model->get_categories();
        $data['current_category'] = $this->get_category_name($category_id);
        $data['category_id'] = $category_id;
        $data['pagination'] = $this->pagination->create_links();
        
        $this->load->view('templates/public_header');
        $this->load->view('catalog/category', $data);
        $this->load->view('templates/footer');
    }
    
    // Halaman detail produk
    public function product($product_id) {
        $data['product'] = $this->Product_model->get_product_detail($product_id);
        
        if (!$data['product']) {
            show_404();
        }
        
        $data['images'] = $this->Product_model->get_product_images($product_id);
        $data['related_products'] = $this->Product_model->get_related_products(
            $data['product']->id_kategori, 
            $product_id
        );
        
        // Generate affiliate link jika user adalah affiliate
        if ($this->session->userdata('user_type') == 'affiliate') {
            $affiliate_code = $this->session->userdata('affiliate_code');
            $data['affiliate_link'] = $this->Product_model->generate_affiliate_link($product_id, $affiliate_code);
        }
        
        $this->load->view('templates/public_header');
        $this->load->view('catalog/product_detail', $data);
        $this->load->view('templates/footer');
    }
    
    // Generate affiliate link via AJAX
    public function generate_affiliate_link_ajax() {
        if (!$this->input->is_ajax_request()) {
            exit('No direct script access allowed');
        }
        
        $product_id = $this->input->post('product_id');
        $affiliate_code = $this->session->userdata('affiliate_code');
        
        if ($affiliate_code) {
            $link = $this->Product_model->generate_affiliate_link($product_id, $affiliate_code);
            
            // Simpan ke database
            $data = array(
                'user_id' => $this->session->userdata('user_id'),
                'user_type' => 'affiliate',
                'product_id' => $product_id,
                'affiliate_link' => $link,
                'custom_slug' => 'aff_' . $product_id . '_' . time(),
                'is_active' => 1
            );
            
            $this->Product_model->save_affiliate_link($data);
            
            echo json_encode(array('status' => 'success', 'link' => $link));
        } else {
            echo json_encode(array('status' => 'error', 'message' => 'Anda bukan affiliate'));
        }
    }
    
    // Helper function untuk mendapatkan nama kategori
    private function get_category_name($category_id) {
        $this->db->select('nama_kategori');
        $this->db->where('id_kategori', $category_id);
        $category = $this->db->get('tbl_kategori')->row();
        
        return $category ? $category->nama_kategori : 'Kategori';
    }
}