<?php
// File: application/controllers/Auth.php (Controller Baru)
// Controller untuk menangani proses login dan logout pengguna backend (admin).

defined('BASEPATH') OR exit('No direct script access allowed');

class Auth extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('User_model');
    }

    public function login() {
        // Jika sudah login, redirect ke dasbor
        if ($this->session->userdata('is_admin_login')) {
            redirect('admin/dashboard');
        }

        $this->form_validation->set_rules('username', 'Username', 'trim|required');
        $this->form_validation->set_rules('password', 'Password', 'trim|required');

        if ($this->form_validation->run() == FALSE) {
            $this->load->view('auth/login');
        } else {
            $username = $this->input->post('username');
            $password = $this->input->post('password');

            $user = $this->User_model->get_user_by_username($username);

            // Verifikasi user dan password
            // Catatan: Skema Anda menyimpan password dalam plain text. Ini SANGAT TIDAK AMAN.
            // Di produksi, gunakan password_hash() saat registrasi dan password_verify() di sini.
            if ($user && $password === $user->password) {
                $session_data = array(
                    'id_user' => $user->id_user,
                    'username' => $user->username,
                    'nama_user' => $user->nama_user,
                    'level_user' => $user->level_user,
                    'is_admin_login' => TRUE
                );
                $this->session->set_userdata($session_data);

                // Redirect ke URL sebelumnya jika ada
                $redirect_url = $this->session->userdata('redirect_url') ? $this->session->userdata('redirect_url') : 'admin/dashboard';
                $this->session->unset_userdata('redirect_url');
                redirect($redirect_url);

            } else {
                $this->session->set_flashdata('error', 'Username atau Password salah.');
                redirect('admin/login');
            }
        }
    }

    public function logout() {
        $this->session->sess_destroy();
        redirect('admin/login');
    }
}
