<?php
// File: application/controllers/Accounting.php
// Controller baru untuk manajemen akuntansi.

class Accounting extends MY_Controller {

    public function __construct() {
        parent::__construct();
        $this->check_permission('view_accounting');
        $this->load->model('Accounting_model');
    }

    public function general_ledger() {
        $data['title'] = "Buku Besar";
        $data['journals'] = $this->Accounting_model->get_all_journal_entries();

        $this->load->view('templates/header', $data);
        $this->load->view('accounting/general_ledger', $data);
        $this->load->view('templates/footer', $data);
    }

    public function profit_and_loss() {
        $data['title'] = "Laporan Laba Rugi";
        $data['accounts'] = $this->Accounting_model->get_profit_and_loss_data();

        // Pisahkan akun pendapatan dan beban
        $data['revenues'] = [];
        $data['expenses'] = [];
        foreach ($data['accounts'] as $account_name => $balance) {
            if (strpos($account_name, 'Pendapatan') !== false) {
                $data['revenues'][$account_name] = $balance;
            } else if (strpos($account_name, 'Beban') !== false) {
                $data['expenses'][$account_name] = $balance;
            }
        }

        $data['total_revenue'] = array_sum($data['revenues']);
        $data['total_expense'] = array_sum($data['expenses']);
        $data['net_profit'] = $data['total_revenue'] - $data['total_expense'];

        $this->load->view('templates/header', $data);
        $this->load->view('accounting/profit_and_loss', $data);
        $this->load->view('templates/footer', $data);
    }
    
    public function cash_flow() {
        $data['title'] = "Laporan Arus Kas";
        $data['cash_flow'] = $this->Accounting_model->get_cash_flow_report();

        $this->load->view('templates/header', $data);
        $this->load->view('accounting/cash_flow', $data);
        $this->load->view('templates/footer', $data);
    }
}
